import time
import asks
import trio

asks.init("trio")
urls = [
    'https://helion.pl',
    'https://www.python.org',
    'https://www.booking.com',
    'http://www.pogodynka.pl',
]

async def get_one(url, t1):
    r = await asks.get(url)
    t2 = time.time()
    print(f"{(t2-t1):.04}\t{len(r.content)}\t{url}")
    
async def get_sites(sites):
    t1 = time.time()
    async with trio.open_nursery() as nursery:
        for url in sites:
            nursery.start_soon(get_one, url, t1)
            
if __name__ == "__main__":
    print("sekundy\tbajty\turl")
    trio.run(get_sites, urls)
